/*!
 * @file       usb_board.h
 *
 * @brief      Header file for USB Board
 *
 * @version    V1.0.0
 *
 * @date       2022-05-25
 *
 */
#ifndef USB_BOARD_H
#define USB_BOARD_H

#include "apm32f4xx.h"
#include "apm32f4xx_misc.h"
#include "apm32f4xx_gpio.h"
#include "apm32f4xx_rcm.h"
#include "apm32f4xx_tmr.h"
#include "drv_usb.h"
#include "Board.h"

#define DEBUG_USART    USART1

void USB_HardwareInit(void);

void USB_Timer_IRQHandler(void);
void USB_usDelay(uint32_t delayTime);
void USB_msDelay(uint32_t delayTime);
void ConfigDelayTimer(void);
void APM_BOARD_COMInit(COM_TypeDef COM, USART_Config_T* configStruct);

#endif
